/***********************************************************************/
/* jpeg reader by Tomasz Bucki (Biki/Altair)                           */
/* v 1.0                                                               */
/***********************************************************************/
/* Warning i don't take any responsibility if this piece               */
/* code will destroy your computer, make you blind or                  */
/* burn your house. Use at your own risk.                              */
/***********************************************************************/
/* what's done:                                                        */
/* - support for restart intervals                                     */
/* - decompression from memory                                         */
/* - YUV images decompression with 1x1,1x2,2x1,2x2 subsampling         */
/*                                                                     */
/* what to do:                                                         */
/* - bugs bugs bugs  GRRR!!!!! bugs they are everywhere!!!             */
/*                                                                     */
/***********************************************************************/
/* 13-04-2002 - first version                                          */
/* 14-04-2002 - cleaned up code                                        */
/* 15-04-2002 - fixed some bugs thanks to people from #coders          */
/***********************************************************************/

//#define RGB_COLOR
#define BGR_COLOR

#include <stdio.h>
#include <stdlib.h>
#include "jpeg.h"

char zy[64]={0,0,1,2,1,0,0,1,2,3,4,3,2,1,0,0,1,2,3,4,5,6,5,4,3,2,1,0,
             0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,2,3,4,5,6,7,7,6,5,4,3,4,5,
             6,7,7,6,5,6,7,7};


char zx[64]={0,1,0,0,1,2,3,2,1,0,0,1,2,3,4,5,4,3,2,1,0,0,1,2,3,4,5,6,
             7,6,5,4,3,2,1,0,1,2,3,4,5,6,7,7,6,5,4,3,2,3,4,5,6,7,7,6,
             5,4,5,6,7,7,6,7};


typedef int thuff[2][257];
typedef int tqtab[64];

struct tcomponent {
       thuff *huff_ac,*huff_dc;
       tqtab *qtab;
       int dc_prev;
       int smpx,smpy;
       float t[16][16];
       } tcomponent;

struct tcomponent component[4];
thuff hufftable_ac[2],hufftable_dc[2];
tqtab qtable[4];
float dctt[8][8];
int prec,ncomp,xres,yres,xblock,yblock;
int blockx,blocky;
unsigned char chr,msk;
unsigned char error_stk[64];
int error_count;
unsigned char rstab[256];
unsigned char *data;
int restart_int;
int bpos,bsize;
unsigned char eof;


/*********************/
/* init jpeg decoder */
/*********************/
void jpeg_init(void) {
int i;
  for (i=0;i<4;i++) component[i].dc_prev=0;
  error_count=0;
  for (i=0;i<256;i++) rstab[i]=0;
  for (i=0xd0;i<0xd8;i++) rstab[i]=1;
}

/****************/
/* report error */
/****************/
void error(int n) {
  if (error_count==64) return;
  error_stk[error_count++]=n;
}

/***********************************/
/* get last error from error stack */
/***********************************/
int jpeg_geterror (void) {
 if (error_count==0) return(0);
                else return (error_stk[--error_count]);
}

/****************************/
/* open and load image file */
/****************************/
char file_open (char *s) {
FILE *f;
int len;

 f=fopen (s,"rb");
 if (f==NULL) {
   error(2); return(0);
 } else {
   fseek(f,0,SEEK_END); bsize=ftell(f); fseek(f,0,SEEK_SET);
   data=(unsigned char*)malloc(bsize);
   len=(int)fread (data,1,bsize,f);
   fclose(f); return(1);
 }
}

/***************/
/* free memory */
/***************/
void file_close(void) {
  free(data);
}

/************/
/* get byte */
/************/
int get_byte(void) {

  if (error_count!=0) return (0);
  if (bpos>=bsize) { 
	eof=1; return(0); 
  } else return (data[bpos++]);
}

/************/
/* get word */
/************/
int get_word(void) {
  if (error_count!=0) return(0);
  return ((get_byte()<<8)+get_byte());
}                  

/***********/
/* get bit */
/***********/
int getbit(void) {
int bit,x;
  
  if (msk==0) {
	chr=get_byte(); if (error_count!=0) return(0);
    if (chr==255) {
	  x=get_byte(); if (error_count!=0) return(0);
      if (x!=0) error(3);
	}
    msk=128;
  }
  bit=chr & msk; if (bit!=0) bit=1;
  msk>>=1; return(bit);
}

/***************/
/* decode word */
/***************/
int word_dec(int n) {
int w,s,i;

  if (n==0) return (0);
  w=getbit(); s=w;
  if (error_count!=0) return (0);
  for (i=1;i<n;i++) w=w+w+getbit();
  if (error_count!=0) return (0);
  if (s==0) w=(w | (0xffffffff << n))+1;
  return (w);
}

/*************************/
/* get image information */
/*************************/
void get_info(void) {
int cn,sf,qt;
int i;
  prec=get_byte(); if (prec!=8) { error(4); return;}  
  yres=get_word(); xres=get_word();
  ncomp=get_byte(); if (ncomp!=3) { error(4); return;}
  // assign quantization table
  for (i=0;i<ncomp;i++) {
    cn=get_byte(); sf=get_byte(); qt=get_byte();
    component[cn-1].qtab=&qtable[qt];
    component[cn-1].smpy=sf&15;
    component[cn-1].smpx=(sf>>4)&15;
  }

  if (component[0].smpx==1) blockx=8;
                       else blockx=16;

  if (component[0].smpy==1) blocky=8;
                       else blocky=16;
  
  xblock=xres/blockx; if ((xres & (blockx-1))!=0) xblock++;
  yblock=yres/blocky; if ((yres & (blocky-1))!=0) yblock++;
}


/**********************************************************/
/*         decode huffman table from jpeg stream          */
/* unpacks huffman length codes and creates huffman codes */
/**********************************************************/
void decode_hufftable(int len) {
int lengths[16];
int b;
int i,j,n,bit;
int length[257];
int symbol[257];
int code,codelen;
int position,free;
thuff *h;

  len-=2;
  while (len>0) {
    b=get_byte(); len--;
    // select huffman tree to load
	switch(b) {
	  case 0  : h=&hufftable_dc[0];
		        break;
      case 1  : h=&hufftable_dc[1];
		        break;
      case 16 : h=&hufftable_ac[0];
		        break;
      case 17 : h=&hufftable_ac[1];		        
	}

    // load huffman tree description
    for (i=0;i<16;i++) lengths[i]=get_byte();
    len-=16; n=0;
    for (i=0;i<16;i++) {
	  len-=lengths[i];
	  for (j=0;j<lengths[i];j++) {
        symbol[n]=get_byte(); length[n++]=i+1;
	  }
	}
	// setup last element to avoid infinite loop later
    length[n]=length[n-1];

	// initialize tree
    for (i=0;i<257;i++) {
	  (*h)[0][i]=32760; 
	  (*h)[1][i]=32760;
	};

	// create huffman tree from codelengths
    free=-255;
    code=0; codelen=length[0];
    for (i=0;i<n;i++) {
      position=256;
	  for (j=codelen-1;j>0;j--) {
        bit=(code>>j)&1;
        if ((*h)[bit][position]==32760) {
            (*h)[bit][position]=free; free++;			
		}
        position=-(*h)[bit][position];
	  }
      bit=code&1;
      (*h)[bit][position]=symbol[i];
      code++;
      while (length[i+1]!=codelen) {
        code<<=1; codelen++;
	  }
	}
  }
}

/************************************/
/* decode symbol using huffman tree */
/************************************/
int huff_dec(thuff *h) {
int ps;
  ps=-256;
  while ((error_count==0) && (ps<0)) ps=(*h)[getbit()][-ps];
  if (ps==32760) error(3);
  return (ps);
}
 

/******************************************/
/* fast inverse discrete cosine transform */
/******************************************/
void fidct(void) {
  float a=0.353553385f;
  float b=0.490392625f;
  float c=0.415734798f;
  float d=0.277785122f;
  float e=0.097545162f;
  float f=0.461939752f;
  float g=0.191341713f;
  float cd=0.6935199499f;
  float be=0.5879377723f;
  float bc=0.9061274529f;
  float de=0.3753302693f;

int i;
float a0,f2,g2,a4,f6,g6;
float s0,s1,s2,s3;
float t0,t1,t2,t3;
float m0,m1,m2,m3;
float h0,h1,h2,h3;
float r0,r1,r2,r3;
float w;


for (i=0;i<8;i++) {
  if ((dctt[i][1]!=0) || (dctt[i][2]!=0) || (dctt[i][3]!=0) ||
      (dctt[i][4]!=0) || (dctt[i][5]!=0) || (dctt[i][6]!=0) || (dctt[i][7]!=0)) {
 
    a0=a*dctt[i][0]; f2=f*dctt[i][2]; g2=g*dctt[i][2];
    a4=a*dctt[i][4]; g6=g*dctt[i][6]; f6=f*dctt[i][6];
    m0=a0+a4;  m1=a0-a4;  m2=f2+g6;
    m3=g2-f6;  s0=m0+m2;  s1=m1+m3;
    s2=m1-m3;  s3=m0-m2;
    h2=dctt[i][7]+dctt[i][1]; h3=dctt[i][7]-dctt[i][1];
    r2=dctt[i][3]+dctt[i][5]; r3=dctt[i][3]-dctt[i][5];
    h0=cd*dctt[i][1]; h1=be*dctt[i][1];
    r0=be*dctt[i][5]; r1=cd*dctt[i][3];
    w=de*r3; t0=h1+r1+e*(h3+r3)-w; t1=h0-r0-d*(h2-r3)-w;
    w=bc*r2; t2=h0+r0+c*(h3+r2)-w; t3=h1-r1-b*(h2+r2)+w;
    dctt[i][0]=s0+t0; dctt[i][1]=s1+t1;
    dctt[i][2]=s2+t2; dctt[i][3]=s3+t3;
    dctt[i][4]=s3-t3; dctt[i][5]=s2-t2;
    dctt[i][6]=s1-t1; dctt[i][7]=s0-t0;
	} else {
    a0=dctt[i][0]*a;
    dctt[i][0]=dctt[i][1]=dctt[i][2]=dctt[i][3]=dctt[i][4]=dctt[i][5]=dctt[i][6]=dctt[i][7]=a0;
	}
  }


for (i=0;i<8;i++) {
  if ((dctt[1][i]!=0) || (dctt[2][i]!=0) || (dctt[3][i]!=0) ||
      (dctt[4][i]!=0) || (dctt[5][i]!=0) || (dctt[6][i]!=0) || (dctt[7][i]!=0)) {

    a0=a*dctt[0][i]; f2=f*dctt[2][i]; g2=g*dctt[2][i];
    a4=a*dctt[4][i]; g6=g*dctt[6][i]; f6=f*dctt[6][i];
    m0=a0+a4;  m1=a0-a4;  m2=f2+g6;
    m3=g2-f6;  s0=m0+m2;  s1=m1+m3;
    s2=m1-m3;  s3=m0-m2;
    h2=dctt[7][i]+dctt[1][i]; h3=dctt[7][i]-dctt[1][i];
    r2=dctt[3][i]+dctt[5][i]; r3=dctt[3][i]-dctt[5][i];
    h0=cd*dctt[1][i]; h1=be*dctt[1][i];
    r0=be*dctt[5][i]; r1=cd*dctt[3][i];
    w=de*r3; t0=h1+r1+e*(h3+r3)-w; t1=h0-r0-d*(h2-r3)-w;
    w=bc*r2; t2=h0+r0+c*(h3+r2)-w; t3=h1-r1-b*(h2+r2)+w;
    dctt[0][i]=s0+t0; dctt[1][i]=s1+t1;
    dctt[2][i]=s2+t2; dctt[3][i]=s3+t3;
    dctt[4][i]=s3-t3; dctt[5][i]=s2-t2;
    dctt[6][i]=s1-t1; dctt[7][i]=s0-t0;
	} else {
    a0=dctt[0][i]*a;
    dctt[0][i]=dctt[1][i]=dctt[2][i]=dctt[3][i]=dctt[4][i]=dctt[5][i]=dctt[6][i]=dctt[7][i]=a0;
	}
  }
}
 
/******************************************************/
/* decode quantization table from file (full support) */
/******************************************************/
void decode_qtable(int len) {
int i;
unsigned char b;

  len-=2;

  while (len>0) {
    b=get_byte(); len--;
    if ((b &16)==0) {
      for (i=0;i<64;i++) qtable[b & 15][i]=get_byte(); len-=64;
	} else {
      for (i=0;i<64;i++) qtable[b & 15][i]=get_word(); len-=128;
	}
  }
}

/*************************/
/* decode block of image */
/*************************/
void decode_block(void) {
int compn,i,j,k,a,b;
int codelen,code;
int cx,cy;
int otab[64];
tqtab *qtab;

for (compn=0;compn<ncomp;compn++) {
  qtab=component[compn].qtab;
  for (cy=0;cy<component[compn].smpy;cy++)
    for (cx=0;cx<component[compn].smpx;cx++)
	  {
	  // clear block
      for (i=0;i<64;i++) otab[i]=0;
	  // decode DC element
      codelen=huff_dec(component[compn].huff_dc); if (error_count!=0) return;
      code=word_dec(codelen); if (error_count!=0) return;
      otab[0]=code+component[compn].dc_prev;
      component[compn].dc_prev=otab[0];
	  // decode AC elements
      i=1;
      while (i<64) {
        codelen=huff_dec(component[compn].huff_ac); if (error_count!=0) return;
        if (codelen==0) i=64;
        else
        if (codelen==0xf0) i+=16;
        else {
          code=word_dec(codelen&15); if (error_count!=0) return;
          i=i+(codelen>>4); otab[i++]=code;
		}
	  }

      // dezigzag and dequantize block
      k=0;
      for (i=0;i<64;i++)
        dctt[zx[i]][zy[i]]=(float)((*qtab)[i]*otab[i]);

	  // inverse cosine transformation
      fidct();

      // fill output block
      b=cx <<3;
      for (i=0;i<8;i++) {
        a=cy <<3;
        for (j=0;j<8;j++) {
          component[compn].t[b][a++]=dctt[i][j]+128;
		}
	    b++;
	  }
	}
  }
}


/**********************************/
/* decode scan data (whole image) */
/**********************************/
void decode_scan(struct tjpeg *p) {
int nnx,nny,i,j,k;
int cr,cg,cb;
float cy,cu,cv;
int ncomp;
int sc,ts;
int scale_ux,scale_uy,scale_vx,scale_vy;
int sca,scb;
int xmin,ymin,xmax,ymax;
int blockn;

  // fill information about image dimensions
  p->xres=xres; p->yres=yres;

  ncomp=get_byte();
  // assign huffman table for each component
  for (i=0;i<ncomp;i++) {
    sc=get_byte(); ts=get_byte();
    component[sc-1].huff_dc=&hufftable_dc[ts >>4];
    component[sc-1].huff_ac=&hufftable_ac[ts & 15];
  }

  get_byte();get_byte();get_byte();

  msk=0;
  // test to avoid division by zero in corrupted files
  if (component[1].smpx==0) error(4);
  if (component[1].smpy==0) error(4);
  if (component[2].smpx==0) error(4);
  if (component[2].smpy==0) error(4);
  if (error_count!=0) return;
  // shift values
  scale_ux=(component[0].smpx/component[1].smpx)-1;
  scale_uy=(component[0].smpy/component[1].smpy)-1;
  scale_vx=(component[0].smpx/component[2].smpx)-1;
  scale_vy=(component[0].smpy/component[2].smpy)-1;

  blockn=0;
  // decode blocks
  for (nny=0;nny<yblock;nny++)
	for (nnx=0;nnx<xblock;nnx++) {
	  // decode block
      decode_block();
	  
	  blockn++;
	  // if restart interval and not the last block , reset decoder
      if ((blockn==restart_int) && ((nnx<xblock-1) || (nny<yblock-1))) {
        blockn=0;
        if (get_byte()!=0xff) error(3);
        if (rstab[get_byte()]==0) error(3);
        msk=0;
        for (i=0;i<ncomp;i++) component[i].dc_prev=0;
	  }
	  
	  // block range
      xmin=nnx*blockx; xmax=xmin+blockx; if (xmax>xres) xmax=xres;
      ymin=nny*blocky; ymax=ymin+blocky; if (ymax>yres) ymax=yres;
      scb=0;

	  // YUV->RGB transformation and outputting data
      for (j=ymin;j<ymax;j++) {
        sca=0;
        k=j*xres+xmin;
        for (i=xmin;i<xmax;i++) {
          cy=component[0].t[sca][scb];
          cu=component[1].t[sca >> scale_ux][scb >> scale_uy]-128.0f;
          cv=component[2].t[sca >> scale_vx][scb >> scale_vy]-128.0f;

          cr=(int)(cy+1.402f*cv);
          cg=(int)(cy-0.34414f*cu-0.71414f*cv);
          cb=(int)(cy+1.772f*cu);
          if (cr<0)   cr=0; if (cr>255) cr=255;
          if (cg<0)   cg=0; if (cg>255) cg=255;
          if (cb<0)   cb=0; if (cb>255) cb=255;
#ifdef RGB_COLOR
          p->image[k]=cb+(cg<<8)+(cr<<16);
#endif
#ifdef BGR_COLOR
          p->image[k]=cr+(cg<<8)+(cb<<16);
#endif
		  k++; sca++;
		}
		scb++;
	  }
	}
}

/************************/
/* end of image routine */
/************************/
void end_of_image() {
	
}


/************************/
/* delete decoded image */
/************************/
void jpeg_delete (struct tjpeg *p) {
  free (p);
}


/************************************/
/* decode image from data in memory */
/************************************/
struct tjpeg *decode_image(void) {
struct tjpeg *p;
unsigned char a;
int w;
unsigned char hdr;

  p=NULL;
  w=get_word();
  // first should be Start Of Image marker
  if (w!=0xffd8) error(3);
  hdr=0;
  // process image data
  while ((eof==0) && (error_count==0)) {
    a=get_byte();
    if (a==0xff) {
      a=get_byte();
      w=get_word();
	  switch (a) {
		  
	  case 0xe0 : if (hdr!=0) break;
                  if (get_byte()!='J') error(1);
                  if (get_byte()!='F') error(1);
                  if (get_byte()!='I') error(1);
                  if (get_byte()!='F') error(1);
                  hdr=1;
				  break;

      case 0xc0 : get_info();
		          break;

	  case 0xc4 : decode_hufftable(w);
				  break;

	  case 0xd9 : end_of_image();
				  break;

	  case 0xda : p=(struct tjpeg*)malloc ((xres*yres+2)*4);
		          decode_scan(p);
				  if (error_count!=0) {
					free(p);
					p=NULL;
				  }
				  break;

      case 0xdb : decode_qtable(w);
                  break;

	  case 0xdd : restart_int=get_word();
		          break;
      default   : while (w>2) {
		            get_byte();
					w--;
				  }
	  }
	}
  }
return(p);
}


/*****************************************/
/* decode image from given memory pointer*/
/*****************************************/
struct tjpeg *jpeg_decode (unsigned char *q,int n) {
  data=q;
  jpeg_init();
  bsize=n;
  restart_int=-1;
  return (decode_image());
}

/*************************/
/* decode jpeg from file */
/*************************/
struct tjpeg *jpeg_load (char *fn) {
struct tjpeg *p;

  jpeg_init();
  restart_int=-1;
  if (file_open(fn)==1) {
	p=decode_image(); file_close(); return(p); 
  } else return(NULL);
}



